<?php

/**
 * Plugin Name: JCC Payment Gateway for WC
 * Plugin URI: https://www.jcc.com.cy/
 * Description: A plugin for adding the JCC Payment Gateway as a payment option in WooCommerce.
 * Author: JCC Payment Systems
 * Author URI: https://www.jcc.com.cy/
 * Version: 1.3.4
 * License: GPLv2
 * License URI: https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
} 

// Make sure WooCommerce is active
if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    return;
}

if (!class_exists('WooCommerce_JCC_Payment_Gateway_Plugin')) :

    class WooCommerce_JCC_Payment_Gateway_Plugin {

        /**
         * Construct the plugin.
         */
        public function __construct() {
            add_action('plugins_loaded', array($this, 'init'));
        }

        /**
         * Initialize the plugin.
         */
        public function init() {
            // Checks if WooCommerce is installed.
            if (class_exists('WC_Payment_Gateway')) {
                // Include our integration class.
                include_once 'includes/class-wc-jcc-payment-gateway.php';

                // Register the payment_gateway.
                add_filter('woocommerce_payment_gateways', array($this, 'add_payment_gateway'));
            } else {
                WC_Admin_Settings::add_error(esc_html__('Looks like you made a mistake with initialising WooCommerce_JCC_Payment_Gateway_Plugin', 'woocommerce_jcc_payment_gateway'));
            }

            // Setting action for plugin
            add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'wc_jcc_payment_gateway_plugin_action_links');
			
			$plugin_data = get_file_data(__FILE__, array('Version' => 'Version'), false);
			$plugin_version = $plugin_data['Version'];
			define ( 'YOURPLUGIN_CURRENT_VERSION', $plugin_version );
        }

        /*
         * Add a new Payment_Gateway to WooCommerce.
         * 
         * As well as defining your class, you need to also tell WooCommerce (WC) that it exists. 
         * Do this by filtering woocommerce_payment_gateways
         */

        public function add_payment_gateway($methods) {
            $methods[] = 'WooCommerce_JCC_Payment_Gateway';
            return $methods;
        }

    }

    $WooCommerce_JCC_Payment_Gateway_Plugin = new WooCommerce_JCC_Payment_Gateway_Plugin(__FILE__);
endif;

function wc_jcc_payment_gateway_plugin_action_links($links) {
    $links[] = '<a href="' . menu_page_url('wc-settings', false) . '&tab=checkout">Settings</a>';
    return $links;
}
